/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentStateBuilder;
import com.technicalitiesmc.lib.circuit.interfaces.BundledSink;
import com.technicalitiesmc.lib.circuit.interfaces.BundledSource;
import com.technicalitiesmc.lib.circuit.interfaces.wire.BundledWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneConductor;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.Wire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.WireConnectionState;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.wire.HorizontalWireComponentBase;
import com.technicalitiesmc.scm.component.wire.WireUtils;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BundledWireComponent
extends HorizontalWireComponentBase<BundledWireComponent>
implements BundledWire {
    private static final DyeColor[] COLORS = DyeColor.values();
    private static final int[] NO_INPUT = new int[COLORS.length];
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final Property<WireConnectionState.Visual> PROP_NEG_X = EnumProperty.m_61587_((String)"neg_x", WireConnectionState.Visual.class);
    public static final Property<WireConnectionState.Visual> PROP_POS_X = EnumProperty.m_61587_((String)"pos_x", WireConnectionState.Visual.class);
    public static final Property<WireConnectionState.Visual> PROP_NEG_Z = EnumProperty.m_61587_((String)"neg_z", WireConnectionState.Visual.class);
    public static final Property<WireConnectionState.Visual> PROP_POS_Z = EnumProperty.m_61587_((String)"pos_z", WireConnectionState.Visual.class);
    private static final InterfaceLookup<BundledWireComponent> INTERFACES = InterfaceLookup.builder().with(BundledSource.class, BundledWireComponent::getBundledSource).with(BundledSink.class, BundledWireComponent::getBundledSink).with(Wire.class, c -> c).with(BundledWire.class, c -> c).build();
    private final int[][] sideInputs = new int[VecDirection.VALUES.length][COLORS.length];
    private final Conductor[] conductors = new Conductor[COLORS.length];
    private final int[] power = new int[COLORS.length];

    public BundledWireComponent(ComponentContext context) {
        super(SCMComponents.BUNDLED_WIRE, context, INTERFACES);
        Arrays.setAll(this.conductors, i -> new Conductor(COLORS[i]));
    }

    public ComponentState getState() {
        return (ComponentState)((ComponentState)((ComponentState)((ComponentState)super.getState().m_61124_(PROP_NEG_X, (Comparable)this.getState(VecDirection.NEG_X).getVisualState())).m_61124_(PROP_POS_X, (Comparable)this.getState(VecDirection.POS_X).getVisualState())).m_61124_(PROP_NEG_Z, (Comparable)this.getState(VecDirection.NEG_Z).getVisualState())).m_61124_(PROP_POS_Z, (Comparable)this.getState(VecDirection.POS_Z).getVisualState());
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.TINY_RGB_REDSTONE.get());
    }

    @Override
    protected WireConnectionState getNextState(VecDirection side, WireConnectionState state, CircuitComponent neighbor, boolean forced) {
        return WireUtils.getNextState(side, state, neighbor, BundledSource.class, BundledSink.class);
    }

    @Override
    protected boolean isValidState(VecDirection side, WireConnectionState state, CircuitComponent neighbor) {
        return WireUtils.isValidState(side, state, neighbor, BundledSource.class, BundledSink.class);
    }

    @Override
    protected void onStateTransition(VecDirection side, WireConnectionState prevState, WireConnectionState newState) {
        Wire wire;
        CircuitComponent neighbor;
        this.sendEvent(CircuitEvent.NEIGHBOR_CHANGED, new VecDirection[]{side});
        if (prevState == WireConnectionState.OUTPUT || newState == WireConnectionState.OUTPUT) {
            this.sendEvent(CircuitEvent.REDSTONE, new VecDirection[]{side});
        }
        if (prevState == WireConnectionState.WIRE || newState == WireConnectionState.WIRE) {
            for (Conductor conductor : this.conductors) {
                conductor.invalidateNetwork();
            }
        }
        if ((neighbor = this.findConnectionTarget(side)) != null && (wire = (Wire)neighbor.getInterface(side.getOpposite(), Wire.class)) != null) {
            wire.setState(side.getOpposite(), newState.getOpposite());
        }
    }

    @Override
    protected void updateSignals(VecDirectionFlags sides) {
        for (VecDirection side : sides) {
            boolean isInput = this.getStateInternal(side) == WireConnectionState.INPUT;
            this.sideInputs[side.ordinal()] = isInput ? this.getInput(side) : NO_INPUT;
        }
        for (int i = 0; i < COLORS.length; ++i) {
            int newInput = 0;
            for (int[] sideInput : this.sideInputs) {
                newInput = Math.max(newInput, sideInput[i]);
            }
            this.conductors[i].setInput(newInput);
        }
    }

    private int[] getInput(VecDirection side) {
        DyeColor color;
        CircuitComponent neighbor = this.findConnectionTarget(side);
        if (neighbor == null) {
            return NO_INPUT;
        }
        BundledSource bundledSource = (BundledSource)neighbor.getInterface(side.getOpposite(), BundledSource.class);
        if (bundledSource != null) {
            return bundledSource.getWeakOutput();
        }
        RedstoneWire wire = (RedstoneWire)neighbor.getInterface(side.getOpposite(), RedstoneWire.class);
        if (wire != null && (color = wire.getColor()) != null) {
            int[] signal = new int[COLORS.length];
            signal[color.m_41060_()] = wire.getConductor().getPower();
            return signal;
        }
        return NO_INPUT;
    }

    public void updateSequential() {
        super.updateSequential();
        for (Conductor conductor : this.conductors) {
            conductor.doSequentialUpdate();
        }
    }

    public RedstoneConductor getConductor(DyeColor color) {
        return this.conductors[color.m_41060_()];
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        ListTag inputs = new ListTag();
        for (int[] side : this.sideInputs) {
            inputs.add((Object)new IntArrayTag(side));
        }
        tag.m_128365_("side_inputs", (Tag)inputs);
        tag.m_128385_("power", this.power);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.m_128441_("wires")) {
            ListTag wires = tag.m_128437_("wires", 10);
            for (int i = 0; i < COLORS.length; ++i) {
                CompoundTag t = wires.m_128728_(i);
                int[] inputs = t.m_128465_("side_inputs");
                for (VecDirection side : VecDirection.VALUES) {
                    this.sideInputs[side.ordinal()][i] = inputs[side.ordinal()];
                }
                this.power[i] = t.m_128451_("power");
            }
        } else {
            ListTag inputs = tag.m_128437_("side_inputs", 11);
            for (int i = 0; i < inputs.size(); ++i) {
                this.sideInputs[i] = inputs.m_128767_(i);
            }
            int[] pow = tag.m_128465_("power");
            System.arraycopy(pow, 0, this.power, 0, pow.length);
        }
    }

    private BundledSource getBundledSource(VecDirection side) {
        if (this.getState(side) != WireConnectionState.OUTPUT) {
            return null;
        }
        return BundledSource.of((int[])this.power, (int[])this.power);
    }

    private BundledSink getBundledSink(VecDirection side) {
        if (this.getState(side) != WireConnectionState.INPUT) {
            return null;
        }
        return BundledSink.instance();
    }

    public static void createState(ComponentStateBuilder builder) {
        builder.add(new Property[]{PROP_NEG_X, PROP_POS_X, PROP_NEG_Z, PROP_POS_Z});
    }

    public final class Conductor
    extends RedstoneConductor {
        private final DyeColor color;

        public Conductor(DyeColor color) {
            this.color = color;
        }

        public int getPower() {
            return BundledWireComponent.this.power[this.color.m_41060_()];
        }

        public void visit(RedstoneConductor.Visitor visitor) {
            for (VecDirection side : VecDirection.VALUES) {
                CircuitComponent neighbor;
                if (BundledWireComponent.this.getStateInternal(side) != WireConnectionState.WIRE || (neighbor = BundledWireComponent.this.findConnectionTarget(side)) == null) continue;
                BundledWire bundledWire = (BundledWire)neighbor.getInterface(side.getOpposite(), BundledWire.class);
                if (bundledWire != null) {
                    visitor.accept(bundledWire.getConductor(this.color));
                    continue;
                }
                RedstoneWire rsWire = (RedstoneWire)neighbor.getInterface(side.getOpposite(), RedstoneWire.class);
                if (rsWire == null || rsWire.getColor() != this.color) continue;
                visitor.accept(rsWire.getConductor());
            }
        }

        public void onPropagated(int newPower) {
            BundledWireComponent.this.updateExternalState(true, () -> {
                BundledWireComponent.this.power[this.color.m_41060_()] = newPower;
            });
            VecDirectionFlags sides = VecDirectionFlags.none();
            for (VecDirection side : VecDirection.VALUES) {
                if (BundledWireComponent.this.getStateInternal(side) != WireConnectionState.OUTPUT) continue;
                sides = (VecDirectionFlags)sides.and((Enum)side);
            }
            BundledWireComponent.this.sendEvent(CircuitEvent.REDSTONE, sides);
        }

        public void scheduleSequentialUpdate() {
            BundledWireComponent.this.scheduleSequential();
        }
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.TINY_RGB_REDSTONE.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && stack.m_204117_(TKLibItemTags.TOOLS_WRENCH)) {
                return InteractionResult.m_19078_((boolean)true);
            }
            return super.use(state, player, hand, sideHit, hit);
        }
    }
}

